/*=======================================================================================

 M24XXX: Testbench for I2C Bus EEPROM Verilog Simulation Model

=========================================================================================

 This program is provided "as is" without warranty of any kind, either
 expressed or implied, including but not limited to, the implied warranty
 of merchantability and fitness for a particular purpose. The entire risk
 as to the quality and performance of the program is with you. Should the
 program prove defective, you assume the cost of all necessary servicing,
 repair or correction.
 
 Copyright 2012, STMicroelectronics Corporation, All Right Reserved.

=======================================================================================*/
//=========================================================
//Testbench for Serial I2C Bus EEPROM Simulation Model
//=========================================================

`include "M24XXX_Parameters.v"

//===========================
module M24XXX_SIM;
//===========================
wire[`Ei_Inputs-1:0] ei;
wire sda,scl,wc,vcc;

integer index;
reg [8*3:0] string;
reg [8*4:0] string2;


//-------M24XXX memory instance
  M24XXX U_M24XXX(.Ei(ei),.SDA(sda),.SCL(scl),.WC(wc),.VCC(vcc));

//-------M24XXX driver instance
  M24XXX_DRV M24XXX_Driver(.Ei(ei),.SDA(sda),.SCL(scl),.WC(wc),.VCC(vcc));

  initial begin :tb
   if (!`Valid_Part) 
   begin
       $display("\n#2#############################################");
       $display("###      NO VAILED DEVICE CHOOSEN   ###");
       $display("##############################################\n");
       $stop;
   end     

   if (`M1Kb_var)  
           string  = "C01";                         
   else if (`M2Kb_var)  
           string  = "C02";        
   else if (`M4Kb_var)    
           string  = "C04";      
   else if (`M8Kb_var) 
           string  = "C08"; 
   else if (`M16Kb_var) 
           string  = "C16";  
   else if (`M32Kb_var)  
           string  = "C32";
   else if (`M64Kb_var) 
           string  = "C64";       
   else if (`M128Kb_var)  
           string  = "128";   
   else if (`M256Kb_var) 
           string  = "256";     
   else if (`M512Kb_var) 
           string  = "512";           
   else if (`M1Mb_var)    
           string  = "M01";    
   else if (`M2Mb_var)  
           string  = "M02";    
   else 
           string  = "XXX";

   if (`A125_var)
          string2 = "A125";
   else if (`S125_var)
          string2 = "125";
   else
          string2 = "XXXX";


   if (`Valid_Part) begin
      $display("\n################################################################################");
      if (`A125_var) begin
         if (`M1Kb_var || `M2Kb_var || `M1Kb_var || `M4Kb_var || `M8Kb_var || `M16Kb_var || `M1Mb_var || `M2Mb_var) begin
            $display("\n#20#############################################");
            $display("###      NO VAILED DEVICE CHOOSEN   ###");
            $display("##############################################\n");
            $stop;
         end
         $display("###     The Selected Model is a AUTOMOTIVE memory, referenced as M24%3s-%4s          ###",string,string2);

         if (`R_var)
            $display("###     Minimum operating voltage range: R=1.8V/125C                                                                ###");
      end
      else if (`S125_var) begin
         if (`M1Kb_var || `M1Mb_var || `M2Mb_var) begin
            $display("\n#A20#############################################");
            $display("###      NO VAILED DEVICE CHOOSEN   ###");
            $display("##############################################\n");
            $stop;
         end
         $display("###     The Selected Model is a AUTOMOTIVE memory, referenced as M24%3s-%3s                ###",string,string2);

         if (`W_var) $display("###     Minimum operating voltage range: W=2.5V                                                                          ###");
      end
      else
         if (`W_var) begin
           if (`IDPAGE)
              $display("###     The Selected Model is a STANDARD memory, referenced as M24%3s-D                        ###",string);
           else
              $display("###     The Selected Model is a STANDARD memory, referenced as M24%3s-W                        ###",string);
           $display("###     Minimum operating voltage range: W=2.5V                                                                        ###");
         end
         else if (`R_var) begin
           if (`IDPAGE)
              $display("###     The Selected Model is a STANDARD memory, referenced as M24%3s-DR                       ###",string);
           else
              $display("###     The Selected Model is a STANDARD memory, referenced as M24%3s-R                        ###",string);
           $display("###     Minimum operating voltage range: R=1.8V                                                                        ###");
         end
         else if (`F_var) begin
           if (`IDPAGE)
              $display("###     The Selected Model is a STANDARD memory, referenced as M24%3s-DF                       ###",string);
           else
              $display("###     The Selected Model is a STANDARD memory, referenced as M24%3s-F                        ###",string);
           $display("###     Minimum operating voltage range: F=1.7V                                                                        ###");
         end
   end

   if (`M1Kb_var)                       
        $display("###     Memory Capacity: 1 Kb                                                                                                       ###");
   else if (`M2Kb_var)          
        $display("###     Memory Capacity: 2 Kb                                                                                                       ###");
   else if (`M4Kb_var)          
        $display("###     Memory Capacity: 4 Kb                                                                                                       ###");
   else if (`M8Kb_var)  
        $display("###     Memory Capacity: 8 Kb                                                                                                       ###");        
   else if (`M16Kb_var)   
        $display("###     Memory Capacity: 16 Kb                                                                                                      ###");              
   else if (`M32Kb_var)  
        $display("###     Memory Capacity: 32 Kb                                                                                                      ###");                     
   else if (`M64Kb_var)        
        $display("###     Memory Capacity: 64 Kb                                                                                                      ###");                     
   else if (`M128Kb_var)     
        $display("###     Memory Capacity: 128 Kb                                                                                                     ###");                        
   else if (`M256Kb_var)      
        $display("###     Memory Capacity: 256 Kb                                                                                                     ###");                          
   else if (`M512Kb_var)       
        $display("###     Memory Capacity: 512 Kb                                                                                                     ###");                          
   else if (`M1Mb_var)        
        $display("###     Memory Capacity: 1 Mb                                                                                                       ###");                          
   else if (`M2Mb_var)  
        $display("###     Memory Capacity: 2 Mb                                                                                                       ###");                                  
   else begin
        $display("\n###############################################");
        $display("###     NO VAILED MEMORY CAPACITY CHOOSEN   ###");
        $display("##############################################\n");
        $stop;
   end

   $display("################################################################################\n");


//-------Memory array initialization
    $display("%t: NOTE: Load memory with Initial content.",$realtime);
    $readmemh("M24XXX_Initial.dat",U_M24XXX.memory);
    $display("%t: NOTE: Initial Load End.\n",$realtime);   

    if (`IDPAGE)
    begin
      $display("%t: NOTE: Load ID memory with Initial content.",$realtime);
      $readmemh("M24XXX_ID_Initial.dat",U_M24XXX.memory_id);
      $display("%t: NOTE: Initial ID Load End.\n",$realtime);
    end

  end

endmodule
